#include <iostream>
#include <vector>
#include <utility>
#include <algorithm>
#include <map>
#include <string>
#include <sstream>
#include <unordered_map>
#include <unordered_set>

void permute(const std::vector<int>& b, const std::vector<uint32_t>& opt, std::vector<int>& p, unsigned long long& r, int depth = 0)
{
	if (depth == b.size())
	{
		r++;
		return;
	}
	auto o = opt[depth];
	for (int i = 0; i < b.size(); i++)
	{
		if ((o & (1 << i)) == 0)
			continue;
		if (std::find(p.begin(), p.begin() + depth, i + 1) != p.begin() + depth)
			continue;
		p[depth] = i + 1;
		permute(b, opt, p, r, depth + 1);
	}
}

int main()
{
	int n;
	std::cin >> n;
	std::vector<int> b(n), f(n, 0);
	for (auto& bb : b)
	{
		std::cin >> bb;
		f[bb - 1]++;
	}
	std::vector<uint32_t> opt(n);
	for (int i = 0; i < n; i++)
	{
		int v = f[i];
		if (v == 0)
		{
			for (auto& e : opt)
				e |= (1 << i);
		}
		if (v == 1)
		{
			int pos = std::distance(b.begin(), std::find(b.begin(), b.end(), i + 1));
			if (pos > 0)
				opt[pos - 1] |= (1 << i);
			opt[pos] |= (1 << i);
			if (pos < n - 1)
				opt[pos + 1] |= (1 << i);
		}
		if (v == 2)
		{
			int pos = std::distance(b.begin(), std::find(b.begin(), b.end(), i + 1));
			if (pos > n - 2)
			{
				std::cout << 0 << std::endl;
				return 0;
			}
			if (b[pos] == b[pos + 1])
			{
				opt[pos] |= (1 << i);
				opt[pos + 1] |= (1 << i);
				continue;
			}
			if (pos > n - 3)
			{
				std::cout << 0 << std::endl;
				return 0;
			}
			if (b[pos] == b[pos + 2])
			{
				opt[pos + 1] |= (1 << i);
				continue;
			}
			std::cout << 0 << std::endl;
			return 0;
		}
		if (v == 3)
		{
			int pos = std::distance(b.begin(), std::find(b.begin(), b.end(), i + 1));
			if (pos > n - 3)
			{
				std::cout << 0 << std::endl;
				return 0;
			}
			if (b[pos] != b[pos + 1] || b[pos] != b[pos + 2])
			{
				std::cout << 0 << std::endl;
				return 0;
			}
			opt[pos + 1] |= 1 << i;
		}
		if (v >= 4)
		{
			std::cout << 0 << std::endl;
			return 0;
		}
	}
	unsigned long long r = 0;
	std::vector<int> v(n);
	for (int i = 0; i < n; i++)
		v[i] = i + 1;
	/*do
	{
		bool ok = true;
		for (int i = 0; i < n; i++)
		{
			if (!(b[i] == v[i] || b[i] == v[std::max(i - 1, 0)] || b[i] == v[std::min(i + 1, n - 1)]))
			{
				ok = false;
			}
		}
		if (ok)
		{
			r++;
			for (auto& vv : v)
				std::cout << vv << ' ';
			std::cout << std::endl;
		}
	} while (std::next_permutation(v.begin(), v.end()));*/
	std::vector<int> p(n);
	permute(b, opt, p, r);
	std::cout << r << std::endl;
}
